	function w = KAISER_WINDOW(N, Amin)
 
	%	Computes the Kaiser window of length N+1
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	 
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	if Amin > 50
		alfa = 0.1102*(Amin-8.7);
	else
		if Amin <= 50 & Amin > 20.96
			alfa = 0.5842*(Amin-20.96)^0.4 + 0.07886*(Amin-20.96);
		else
			alfa = 0;
		end
	end
	M = N+1;
	for n = 1:M
		w(n) = besseli(0,alfa*sqrt(1-((N-2*n)/M)^2))/besseli(0,alfa);
	end
